/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.perks;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.network.PacketBuffer;

public final class FusionConfiguration {
    private final Upgrades upgrades;
    private final Swaps swaps;
    private final BreakChanceReductions breakChanceReductions;

    public FusionConfiguration(Upgrades upgrades, Swaps swaps, BreakChanceReductions reductions) {
        this.upgrades = upgrades;
        this.swaps = swaps;
        this.breakChanceReductions = reductions;
    }

    public Upgrades getUpgrades() {
        return this.upgrades;
    }

    public Swaps getSwaps() {
        return this.swaps;
    }

    public BreakChanceReductions getBreakChanceReductions() {
        return this.breakChanceReductions;
    }

    public void encode(PacketBuffer buffer) {
        this.upgrades.encode(buffer);
        this.swaps.encode(buffer);
        this.breakChanceReductions.encode(buffer);
    }

    public static FusionConfiguration decode(PacketBuffer buffer) {
        return new FusionConfiguration(Upgrades.decode(buffer), Swaps.decode(buffer), BreakChanceReductions.decode(buffer));
    }

    public static final class BreakChanceReduction {
        private final int orbCount;
        private final float multiplier;

        public BreakChanceReduction(int orbCount, float multiplier) {
            this.orbCount = orbCount;
            this.multiplier = multiplier;
        }

        public int getOrbCount() {
            return this.orbCount;
        }

        public float getMultiplier() {
            return this.multiplier;
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.orbCount);
            buffer.writeFloat(this.multiplier);
        }

        public static BreakChanceReduction decode(PacketBuffer buffer) {
            return new BreakChanceReduction(buffer.readInt(), buffer.readFloat());
        }
    }

    public static final class BreakChanceReductions {
        private final Int2ObjectMap<BreakChanceReduction> map;

        public BreakChanceReductions(Int2ObjectMap<BreakChanceReduction> map) {
            this.map = map;
        }

        public BreakChanceReduction getReductionForOrbs(int orbs) {
            return (BreakChanceReduction)this.map.get(orbs);
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.map.size());
            this.map.values().forEach(reduction -> reduction.encode(buffer));
        }

        public static BreakChanceReductions decode(PacketBuffer buffer) {
            int count = buffer.readInt();
            Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
            for (int i = 0; i < count; ++i) {
                BreakChanceReduction reduction = BreakChanceReduction.decode(buffer);
                result.put(reduction.orbCount, (Object)reduction);
            }
            return new BreakChanceReductions((Int2ObjectMap<BreakChanceReduction>)result);
        }
    }

    public static final class Swap {
        private final int count;
        private final int price;
        private final float chance;

        public Swap(int count, int price, float chance) {
            this.count = count;
            this.price = price;
            this.chance = chance;
        }

        public int getPrice() {
            return this.price;
        }

        public float getChance() {
            return this.chance;
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.count);
            buffer.writeInt(this.price);
            buffer.writeFloat(this.chance);
        }

        public static Swap decode(PacketBuffer buffer) {
            return new Swap(buffer.readInt(), buffer.readInt(), buffer.readFloat());
        }
    }

    public static final class Upgrade {
        private final int level;
        private final float breakChance;
        private final int price;

        public Upgrade(int level, float breakChance, int price) {
            this.level = level;
            this.breakChance = breakChance;
            this.price = price;
        }

        public float getBreakChance() {
            return this.breakChance;
        }

        public int getPrice() {
            return this.price;
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.level);
            buffer.writeFloat(this.breakChance);
            buffer.writeInt(this.price);
        }

        public static Upgrade decode(PacketBuffer buffer) {
            return new Upgrade(buffer.readInt(), buffer.readFloat(), buffer.readInt());
        }
    }

    public static final class Swaps {
        private final Int2ObjectMap<Swap> countToSwapMap = new Int2ObjectOpenHashMap();

        public Swaps(Swap[] swaps) {
            for (Swap swap : swaps) {
                this.countToSwapMap.put(swap.count, (Object)swap);
            }
        }

        public Swap getSwapStat(int orbCount) {
            return (Swap)this.countToSwapMap.get(orbCount);
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.countToSwapMap.size());
            this.countToSwapMap.values().forEach(swap -> swap.encode(buffer));
        }

        public static Swaps decode(PacketBuffer buffer) {
            Swap[] swaps = new Swap[buffer.readInt()];
            for (int i = 0; i < swaps.length; ++i) {
                swaps[i] = Swap.decode(buffer);
            }
            return new Swaps(swaps);
        }
    }

    public static final class Upgrades {
        private final Int2ObjectMap<Upgrade> levelUpgradeMap = new Int2ObjectOpenHashMap();

        public Upgrades(Upgrade[] upgrades) {
            for (Upgrade upgrade : upgrades) {
                this.levelUpgradeMap.put(upgrade.level, (Object)upgrade);
            }
        }

        public Upgrade getUpgradeStat(int targetLevel) {
            return (Upgrade)this.levelUpgradeMap.get(targetLevel);
        }

        public void encode(PacketBuffer buffer) {
            buffer.writeInt(this.levelUpgradeMap.size());
            this.levelUpgradeMap.values().forEach(upgrade -> upgrade.encode(buffer));
        }

        public static Upgrades decode(PacketBuffer buffer) {
            int l = buffer.readInt();
            Upgrade[] upgrades = new Upgrade[l];
            for (int i = 0; i < l; ++i) {
                upgrades[i] = Upgrade.decode(buffer);
            }
            return new Upgrades(upgrades);
        }
    }
}

